<?php
class ControllerExtensionShippinghitcpost extends Controller {
	private $error = array();
	public function install() {
		$this->db->query("CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . "hittech_cpost_details_new` (
		  `id` int(11) NOT NULL AUTO_INCREMENT,
		  `order_id` text NOT NULL,
		  `shipment_id` text NOT NULL,
		  `tracking_num` text NOT NULL,
		  `shipping_label` text COLLATE utf8_bin NOT NULL,
		  `invoice` text COLLATE utf8_bin NOT NULL,
		  `return_label` text COLLATE utf8_bin  NULL,
		  `return_invoice` text COLLATE utf8_bin  NULL,
		  `one` text COLLATE utf8_bin  NULL,
		  `two` text COLLATE utf8_bin  NULL,
		  `three` text COLLATE utf8_bin  NULL,
		  PRIMARY KEY (`id`)
		)");
	}
	public function index() {
		$this->install();
		$this->load->language('extension/shipping/hitcpost');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('setting/setting');
		
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && isset($_POST['btn_licence_activation'])) {

			if (!$this->request->post['shipping_hitcpost_licence_licence'] && empty($this->request->post['shipping_hitcpost_licence_licence'])) {
			return 'Enter Licence Key';
			}
			if (!$this->request->post['shipping_hitcpost_licence_email'] && empty($this->request->post['shipping_hitcpost_licence_email'])) {
				return 'Enter Purchased Email Address';
			}

				$licence_key = trim($this->request->post['shipping_hitcpost_licence_licence']);
				$licence_email = trim($this->request->post['shipping_hitcpost_licence_email']);
				$licenc_check_url = "https://hittechmarket.com/?edd_action=check_license&item_id=2288&license=".$licence_key;
				$ch = curl_init();
				curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
				curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
				curl_setopt($ch, CURLOPT_URL, $licenc_check_url);
				$result = curl_exec($ch);
				curl_close($ch);
				$obj = json_decode($result);
				
				if(isset($obj->success) && $obj->success == true)
				{
					if(isset($obj->license) && ($obj->license == 'inactive' || $obj->license == 'valid'))
					{
						if(isset($obj->customer_email) && $obj->customer_email == $licence_email)
						{
							if(isset($obj->activations_left) && $obj->activations_left != '0')
							{
								$licenc_activate_url = "https://hittechmarket.com/?edd_action=activate_license&item_id=2288&license=".$licence_key;
								$ch = curl_init();
								curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
								curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
								curl_setopt($ch, CURLOPT_URL, $licenc_activate_url);
								$result = curl_exec($ch);
								curl_close($ch);
								$obj = json_decode($result);
								
								if(isset($obj->expires))
								{
									$this->request->post['shipping_hitcpost_licence_expires'] = $obj->expires;
									$this->request->post['shipping_hitcpost_licence_status_licence'] = 'Activated';
								}

								}else
							{
								$this->error['warning'] = 'Licence Is Already Activated In another one Site. Report HIT TECH.';
							}

						}else
						{
							$this->error['warning'] = 'Purchased Email Address is Invalid.';
						}

					}else
					{
						$this->error['warning'] = 'The Licence is not valid for this Product.';
					}
				}
				else{
					$this->error['warning'] = 'invalid Licence Key';
				}
		$this->model_setting_setting->editSetting('shipping_hitcpost_licence', $this->request->post);
			
		}else if (($this->request->server['REQUEST_METHOD'] == 'POST') && isset($_POST['btn_renew_activation'])) {

			if (!$this->request->post['shipping_hitcpost_renew_licence'] && empty($this->request->post['shipping_hitcpost_renew_licence'])) {
				$this->error['warning'] = 'Enter Licence Key.';
			return 'Enter Licence Key';
			}
			if (!$this->request->post['shipping_hitcpost_renew_email'] && empty($this->request->post['shipping_hitcpost_renew_email'])) {
				$this->error['warning'] = 'Enter Purchased Email Address.';
				return 'Enter Purchased Email Address';
			}

				$licence_key = trim($this->request->post['shipping_hitcpost_renew_licence']);
				$licence_email = trim($this->request->post['shipping_hitcpost_renew_email']);
				$licenc_check_url = "https://hittechmarket.com/?edd_action=check_license&item_id=2288&license=".$licence_key;
				$ch = curl_init();
				curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
				curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
				curl_setopt($ch, CURLOPT_URL, $licenc_check_url);
				$result = curl_exec($ch);
				curl_close($ch);
				$obj = json_decode($result);
				
				if(isset($obj->success) && $obj->success == true)
				{
					if(isset($obj->license) && ($obj->license == 'inactive' || $obj->license == 'valid'))
					{
						if(isset($obj->customer_email) && $obj->customer_email == $licence_email)
						{
							
							$this->request->post['shipping_hitcpost_renew_expires'] = $obj->expires;
						}else
						{
							$this->error['warning'] = 'Purchased Email Address is Invalid.';
						}

					}else
					{
						$this->error['warning'] = 'The Licence is not valid for this Product.';
					}
				}
				else{
					$this->error['warning'] = 'invalid Licence Key';
				}
		$this->model_setting_setting->editSetting('shipping_hitcpost_renew', $this->request->post);
			
		}else if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {

			$this->model_setting_setting->editSetting('shipping_hitcpost', $this->request->post);
// echo '<pre>';
// print_r($this->model_setting_setting->getSetting('shipping_hitcpost'));
// die();
			$this->session->data['success'] = $this->language->get('text_success');

			$this->response->redirect($this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=shipping', true));

		}


		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}
		
		if (isset($this->error['name'])) {
			$data['error_name'] = $this->error['name'];
		} else {
			$data['error_name'] = '';
		}

		if (isset($this->error['password'])) {
			$data['error_password'] = $this->error['password'];
		} else {
			$data['error_password'] = '';
		}

		if (isset($this->error['customer'])) {
			$data['error_customer'] = $this->error['customer'];
		} else {
			$data['error_customer'] = '';
		}

		if (isset($this->error['contract'])) {
			$data['error_contract'] = $this->error['contract'];
		} else {
			$data['error_contract'] = '';
		}
		
		if (isset($this->error['postcode'])) {
			$data['error_postcode'] = $this->error['postcode'];
		} else {
			$data['error_postcode'] = '';
		}

		if (isset($this->error['dimension'])) {
			$data['error_dimension'] = $this->error['dimension'];
		} else {
			$data['error_dimension'] = '';
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_extension'),
			'href' => $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=shipping', true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('extension/shipping/hitcpost', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['action'] = $this->url->link('extension/shipping/hitcpost', 'user_token=' . $this->session->data['user_token'], true);

		$data['cancel'] = $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=shipping', true);

		
		if (isset($this->request->post['shipping_hitcpost_test'])) {
			$data['shipping_hitcpost_test'] = $this->request->post['shipping_hitcpost_test'];
		} else {
			$data['shipping_hitcpost_test'] = $this->config->get('shipping_hitcpost_test');
		}
		
		if (isset($this->request->post['shipping_hitcpost_username'])) {
			$data['shipping_hitcpost_username'] = $this->request->post['shipping_hitcpost_username'];
		} else {
			$data['shipping_hitcpost_username'] = $this->config->get('shipping_hitcpost_username');
		}

		if (isset($this->request->post['shipping_hitcpost_password'])) {
			$data['shipping_hitcpost_password'] = $this->request->post['shipping_hitcpost_password'];
		} else {
			$data['shipping_hitcpost_password'] = $this->config->get('shipping_hitcpost_password');
		}

		if (isset($this->request->post['shipping_hitcpost_customer_num'])) {
			$data['shipping_hitcpost_customer_num'] = $this->request->post['shipping_hitcpost_customer_num'];
		} else {
			$data['shipping_hitcpost_customer_num'] = $this->config->get('shipping_hitcpost_customer_num');
		}

		if (isset($this->request->post['shipping_hitcpost_contract_id'])) {
			$data['shipping_hitcpost_contract_id'] = $this->request->post['shipping_hitcpost_contract_id'];
		} else {
			$data['shipping_hitcpost_contract_id'] = $this->config->get('shipping_hitcpost_contract_id');
		}
		
		if (isset($this->request->post['shipping_hitcpost_status'])) {
			$data['shipping_hitcpost_status'] = $this->request->post['shipping_hitcpost_status'];
		} else {
			$data['shipping_hitcpost_status'] = $this->config->get('shipping_hitcpost_status');
		}

		if (isset($this->request->post['shipping_hitcpost_sort_order'])) {
			$data['shipping_hitcpost_sort_order'] = $this->request->post['shipping_hitcpost_sort_order'];
		} else {
			$data['shipping_hitcpost_sort_order'] = $this->config->get('shipping_hitcpost_sort_order');
		}

		if (isset($this->request->post['shipping_hitcpost_shipper_name'])) {
			$data['shipping_hitcpost_shipper_name'] = $this->request->post['shipping_hitcpost_shipper_name'];
		} else {
			$data['shipping_hitcpost_shipper_name'] = $this->config->get('shipping_hitcpost_shipper_name');
		}
		
		if (isset($this->request->post['shipping_hitcpost_company_name'])) {
			$data['shipping_hitcpost_company_name'] = $this->request->post['shipping_hitcpost_company_name'];
		} else {
			$data['shipping_hitcpost_company_name'] = $this->config->get('shipping_hitcpost_company_name');
		}
		
		if (isset($this->request->post['shipping_hitcpost_phone_num'])) {
			$data['shipping_hitcpost_phone_num'] = $this->request->post['shipping_hitcpost_phone_num'];
		} else {
			$data['shipping_hitcpost_phone_num'] = $this->config->get('shipping_hitcpost_phone_num');
		}
		
		if (isset($this->request->post['shipping_hitcpost_email_addr'])) {
			$data['shipping_hitcpost_email_addr'] = $this->request->post['shipping_hitcpost_email_addr'];
		} else {
			$data['shipping_hitcpost_email_addr'] = $this->config->get('shipping_hitcpost_email_addr');
		}
		
		if (isset($this->request->post['shipping_hitcpost_address1'])) {
			$data['shipping_hitcpost_address1'] = $this->request->post['shipping_hitcpost_address1'];
		} else {
			$data['shipping_hitcpost_address1'] = $this->config->get('shipping_hitcpost_address1');
		}
		
		if (isset($this->request->post['shipping_hitcpost_address2'])) {
			$data['shipping_hitcpost_address2'] = $this->request->post['shipping_hitcpost_address2'];
		} else {
			$data['shipping_hitcpost_address2'] = $this->config->get('shipping_hitcpost_address2');
		}
		
		
		if (isset($this->request->post['shipping_hitcpost_city'])) {
			$data['shipping_hitcpost_city'] = $this->request->post['shipping_hitcpost_city'];
		} else {
			$data['shipping_hitcpost_city'] = $this->config->get('shipping_hitcpost_city');
		}
		
		
		if (isset($this->request->post['shipping_hitcpost_state'])) {
			$data['shipping_hitcpost_state'] = $this->request->post['shipping_hitcpost_state'];
		} else {
			$data['shipping_hitcpost_state'] = $this->config->get('shipping_hitcpost_state');
		}
		
		
		if (isset($this->request->post['shipping_hitcpost_country_code'])) {
			$data['shipping_hitcpost_country_code'] = $this->request->post['shipping_hitcpost_country_code'];
		} else {
			$data['shipping_hitcpost_country_code'] = $this->config->get('shipping_hitcpost_country_code');
		}
		$data['countrylist'] = array(
			'AF' => 'Afghanistan',
			'AX' => 'Aland Islands',
			'AL' => 'Albania',
			'DZ' => 'Algeria',
			'AS' => 'American Samoa',
			'AD' => 'Andorra',
			'AO' => 'Angola',
			'AI' => 'Anguilla',
			'AQ' => 'Antarctica',
			'AG' => 'Antigua and Barbuda',
			'AR' => 'Argentina',
			'AM' => 'Armenia',
			'AW' => 'Aruba',
			'AU' => 'Australia',
			'AT' => 'Austria',
			'AZ' => 'Azerbaijan',
			'BS' => 'Bahamas',
			'BH' => 'Bahrain',
			'BD' => 'Bangladesh',
			'BB' => 'Barbados',
			'BY' => 'Belarus',
			'BE' => 'Belgium',
			'BZ' => 'Belize',
			'BJ' => 'Benin',
			'BM' => 'Bermuda',
			'BT' => 'Bhutan',
			'BO' => 'Bolivia',
			'BQ' => 'Bonaire, Saint Eustatius and Saba',
			'BA' => 'Bosnia and Herzegovina',
			'BW' => 'Botswana',
			'BV' => 'Bouvet Island',
			'BR' => 'Brazil',
			'IO' => 'British Indian Ocean Territory',
			'VG' => 'British Virgin Islands',
			'BN' => 'Brunei',
			'BG' => 'Bulgaria',
			'BF' => 'Burkina Faso',
			'BI' => 'Burundi',
			'KH' => 'Cambodia',
			'CM' => 'Cameroon',
			'CA' => 'Canada',
			'CV' => 'Cape Verde',
			'KY' => 'Cayman Islands',
			'CF' => 'Central African Republic',
			'TD' => 'Chad',
			'CL' => 'Chile',
			'CN' => 'China',
			'CX' => 'Christmas Island',
			'CC' => 'Cocos Islands',
			'CO' => 'Colombia',
			'KM' => 'Comoros',
			'CK' => 'Cook Islands',
			'CR' => 'Costa Rica',
			'HR' => 'Croatia',
			'CU' => 'Cuba',
			'CW' => 'Curacao',
			'CY' => 'Cyprus',
			'CZ' => 'Czech Republic',
			'CD' => 'Democratic Republic of the Congo',
			'DK' => 'Denmark',
			'DJ' => 'Djibouti',
			'DM' => 'Dominica',
			'DO' => 'Dominican Republic',
			'TL' => 'East Timor',
			'EC' => 'Ecuador',
			'EG' => 'Egypt',
			'SV' => 'El Salvador',
			'GQ' => 'Equatorial Guinea',
			'ER' => 'Eritrea',
			'EE' => 'Estonia',
			'ET' => 'Ethiopia',
			'FK' => 'Falkland Islands',
			'FO' => 'Faroe Islands',
			'FJ' => 'Fiji',
			'FI' => 'Finland',
			'FR' => 'France',
			'GF' => 'French Guiana',
			'PF' => 'French Polynesia',
			'TF' => 'French Southern Territories',
			'GA' => 'Gabon',
			'GM' => 'Gambia',
			'GE' => 'Georgia',
			'DE' => 'Germany',
			'GH' => 'Ghana',
			'GI' => 'Gibraltar',
			'GR' => 'Greece',
			'GL' => 'Greenland',
			'GD' => 'Grenada',
			'GP' => 'Guadeloupe',
			'GU' => 'Guam',
			'GT' => 'Guatemala',
			'GG' => 'Guernsey',
			'GN' => 'Guinea',
			'GW' => 'Guinea-Bissau',
			'GY' => 'Guyana',
			'HT' => 'Haiti',
			'HM' => 'Heard Island and McDonald Islands',
			'HN' => 'Honduras',
			'HK' => 'Hong Kong',
			'HU' => 'Hungary',
			'IS' => 'Iceland',
			'IN' => 'India',
			'ID' => 'Indonesia',
			'IR' => 'Iran',
			'IQ' => 'Iraq',
			'IE' => 'Ireland',
			'IM' => 'Isle of Man',
			'IL' => 'Israel',
			'IT' => 'Italy',
			'CI' => 'Ivory Coast',
			'JM' => 'Jamaica',
			'JP' => 'Japan',
			'JE' => 'Jersey',
			'JO' => 'Jordan',
			'KZ' => 'Kazakhstan',
			'KE' => 'Kenya',
			'KI' => 'Kiribati',
			'XK' => 'Kosovo',
			'KW' => 'Kuwait',
			'KG' => 'Kyrgyzstan',
			'LA' => 'Laos',
			'LV' => 'Latvia',
			'LB' => 'Lebanon',
			'LS' => 'Lesotho',
			'LR' => 'Liberia',
			'LY' => 'Libya',
			'LI' => 'Liechtenstein',
			'LT' => 'Lithuania',
			'LU' => 'Luxembourg',
			'MO' => 'Macao',
			'MK' => 'Macedonia',
			'MG' => 'Madagascar',
			'MW' => 'Malawi',
			'MY' => 'Malaysia',
			'MV' => 'Maldives',
			'ML' => 'Mali',
			'MT' => 'Malta',
			'MH' => 'Marshall Islands',
			'MQ' => 'Martinique',
			'MR' => 'Mauritania',
			'MU' => 'Mauritius',
			'YT' => 'Mayotte',
			'MX' => 'Mexico',
			'FM' => 'Micronesia',
			'MD' => 'Moldova',
			'MC' => 'Monaco',
			'MN' => 'Mongolia',
			'ME' => 'Montenegro',
			'MS' => 'Montserrat',
			'MA' => 'Morocco',
			'MZ' => 'Mozambique',
			'MM' => 'Myanmar',
			'NA' => 'Namibia',
			'NR' => 'Nauru',
			'NP' => 'Nepal',
			'NL' => 'Netherlands',
			'NC' => 'New Caledonia',
			'NZ' => 'New Zealand',
			'NI' => 'Nicaragua',
			'NE' => 'Niger',
			'NG' => 'Nigeria',
			'NU' => 'Niue',
			'NF' => 'Norfolk Island',
			'KP' => 'North Korea',
			'MP' => 'Northern Mariana Islands',
			'NO' => 'Norway',
			'OM' => 'Oman',
			'PK' => 'Pakistan',
			'PW' => 'Palau',
			'PS' => 'Palestinian Territory',
			'PA' => 'Panama',
			'PG' => 'Papua New Guinea',
			'PY' => 'Paraguay',
			'PE' => 'Peru',
			'PH' => 'Philippines',
			'PN' => 'Pitcairn',
			'PL' => 'Poland',
			'PT' => 'Portugal',
			'PR' => 'Puerto Rico',
			'QA' => 'Qatar',
			'CG' => 'Republic of the Congo',
			'RE' => 'Reunion',
			'RO' => 'Romania',
			'RU' => 'Russia',
			'RW' => 'Rwanda',
			'BL' => 'Saint Barthelemy',
			'SH' => 'Saint Helena',
			'KN' => 'Saint Kitts and Nevis',
			'LC' => 'Saint Lucia',
			'MF' => 'Saint Martin',
			'PM' => 'Saint Pierre and Miquelon',
			'VC' => 'Saint Vincent and the Grenadines',
			'WS' => 'Samoa',
			'SM' => 'San Marino',
			'ST' => 'Sao Tome and Principe',
			'SA' => 'Saudi Arabia',
			'SN' => 'Senegal',
			'RS' => 'Serbia',
			'SC' => 'Seychelles',
			'SL' => 'Sierra Leone',
			'SG' => 'Singapore',
			'SX' => 'Sint Maarten',
			'SK' => 'Slovakia',
			'SI' => 'Slovenia',
			'SB' => 'Solomon Islands',
			'SO' => 'Somalia',
			'ZA' => 'South Africa',
			'GS' => 'South Georgia and the South Sandwich Islands',
			'KR' => 'South Korea',
			'SS' => 'South Sudan',
			'ES' => 'Spain',
			'LK' => 'Sri Lanka',
			'SD' => 'Sudan',
			'SR' => 'Suriname',
			'SJ' => 'Svalbard and Jan Mayen',
			'SZ' => 'Swaziland',
			'SE' => 'Sweden',
			'CH' => 'Switzerland',
			'SY' => 'Syria',
			'TW' => 'Taiwan',
			'TJ' => 'Tajikistan',
			'TZ' => 'Tanzania',
			'TH' => 'Thailand',
			'TG' => 'Togo',
			'TK' => 'Tokelau',
			'TO' => 'Tonga',
			'TT' => 'Trinidad and Tobago',
			'TN' => 'Tunisia',
			'TR' => 'Turkey',
			'TM' => 'Turkmenistan',
			'TC' => 'Turks and Caicos Islands',
			'TV' => 'Tuvalu',
			'VI' => 'U.S. Virgin Islands',
			'UG' => 'Uganda',
			'UA' => 'Ukraine',
			'AE' => 'United Arab Emirates',
			'GB' => 'United Kingdom',
			'US' => 'United States',
			'UM' => 'United States Minor Outlying Islands',
			'UY' => 'Uruguay',
			'UZ' => 'Uzbekistan',
			'VU' => 'Vanuatu',
			'VA' => 'Vatican',
			'VE' => 'Venezuela',
			'VN' => 'Vietnam',
			'WF' => 'Wallis and Futuna',
			'EH' => 'Western Sahara',
			'YE' => 'Yemen',
			'ZM' => 'Zambia',
			'ZW' => 'Zimbabwe',
		);
		
		if (isset($this->request->post['shipping_hitcpost_postcode'])) {
			$data['shipping_hitcpost_postcode'] = $this->request->post['shipping_hitcpost_postcode'];
		} else {
			$data['shipping_hitcpost_postcode'] = $this->config->get('shipping_hitcpost_postcode');
		}
		
		if (isset($this->request->post['shipping_hitcpost_realtime_rates'])) {
			$data['shipping_hitcpost_realtime_rates'] = $this->request->post['shipping_hitcpost_realtime_rates'];
		} else {
			$data['shipping_hitcpost_realtime_rates'] = $this->config->get('shipping_hitcpost_realtime_rates');
		}
		if (isset($this->request->post['shipping_hitcpost_rate_tax'])) {
			$data['shipping_hitcpost_rate_tax'] = $this->request->post['shipping_hitcpost_rate_tax'];
		} else {
			$data['shipping_hitcpost_rate_tax'] = $this->config->get('shipping_hitcpost_rate_tax');
		}
		// if (isset($this->request->post['shipping_hitcpost_insurance'])) {
		// 	$data['shipping_hitcpost_insurance'] = $this->request->post['shipping_hitcpost_insurance'];
		// } else {
		// 	$data['shipping_hitcpost_insurance'] = $this->config->get('shipping_hitcpost_insurance');
		// }
		
		if (isset($this->request->post['shipping_hitcpost_display_time'])) {
			$data['shipping_hitcpost_display_time'] = $this->request->post['shipping_hitcpost_display_time'];
		} else {
			$data['shipping_hitcpost_display_time'] = $this->config->get('shipping_hitcpost_display_time');
		}
		if (isset($this->request->post['shipping_hitcpost_front_end_logs'])) {
			$data['shipping_hitcpost_front_end_logs'] = $this->request->post['shipping_hitcpost_front_end_logs'];
		} else {
			$data['shipping_hitcpost_front_end_logs'] = $this->config->get('shipping_hitcpost_front_end_logs');
		}
			
		// if (isset($this->request->post['shipping_hitcpost_rate_type'])) {
		// 	$data['shipping_hitcpost_rate_type'] = $this->request->post['shipping_hitcpost_rate_type'];
		// } else {
		// 	$data['shipping_hitcpost_rate_type'] = $this->config->get('shipping_hitcpost_rate_type');
		// }
		
		
		if (isset($this->request->post['shipping_hitcpost_service'])) {
			$data['shipping_hitcpost_service'] = $this->request->post['shipping_hitcpost_service'];
		} elseif ($this->config->has('shipping_hitcpost_service')) {
			$data['shipping_hitcpost_service'] = $this->config->get('shipping_hitcpost_service');
		} else {
			$data['shipping_hitcpost_service'] = array();
		}

		$data['services'] = array();

		$data['services'][] = array(
			'text'  => $this->language->get('DOM_RP'),
			'value' => 'DOM_RP'
		);

		$data['services'][] = array(
			'text'  => $this->language->get('DOM_EP'),
			'value' => 'DOM_EP'
		);

		$data['services'][] = array(
			'text'  => $this->language->get('DOM_XP'),
			'value' => 'DOM_XP'
		);

		$data['services'][] = array(
			'text'  => $this->language->get('DOM_XP_CERT'),
			'value' => 'DOM_XP_CERT'
		);

		$data['services'][] = array(
			'text'  => $this->language->get('DOM_PC'),
			'value' => 'DOM_PC'
		);

		$data['services'][] = array(
			'text'  => $this->language->get('DOM_LIB'),
			'value' => 'DOM_LIB'
		);

		$data['services'][] = array(
			'text'  => $this->language->get('USA_EP'),
			'value' => 'USA_EP'
		);

		$data['services'][] = array(
			'text'  => $this->language->get('USA_PW_ENV'),
			'value' => 'USA_PW_ENV'
		);

		$data['services'][] = array(
			'text'  => $this->language->get('USA_PW_PAK'),
			'value' => 'USA_PW_PAK'
		);

		$data['services'][] = array(
			'text'  => $this->language->get('USA_PW_PARCEL'),
			'value' => 'USA_PW_PARCEL'
		);

		$data['services'][] = array(
			'text'  => $this->language->get('USA_SP_AIR'),
			'value' => 'USA_SP_AIR'
		);

		$data['services'][] = array(
			'text'  => $this->language->get('USA_TP'),
			'value' => 'USA_TP'
		);

		$data['services'][] = array(
			'text'  => $this->language->get('USA_XP'),
			'value' => 'USA_XP'
		);

		$data['services'][] = array(
			'text'  => $this->language->get('INT_XP'),
			'value' => 'INT_XP'
		);

		$data['services'][] = array(
			'text'  => $this->language->get('INT_IP_AIR'),
			'value' => 'INT_IP_AIR'
		);

		$data['services'][] = array(
			'text'  => $this->language->get('INT_IP_SURF'),
			'value' => 'INT_IP_SURF'
		);

		$data['services'][] = array(
			'text'  => $this->language->get('INT_PW_ENV'),
			'value' => 'INT_PW_ENV'
		);

		$data['services'][] = array(
			'text'  => $this->language->get('INT_PW_PAK'),
			'value' => 'INT_PW_PAK'
		);

		$data['services'][] = array(
			'text'  => $this->language->get('INT_PW_PARCEL'),
			'value' => 'INT_PW_PARCEL'
		);

		$data['services'][] = array(
			'text'  => $this->language->get('INT_SP_AIR'),
			'value' => 'INT_SP_AIR'
		);

		$data['services'][] = array(
			'text'  => $this->language->get('INT_SP_SURF'),
			'value' => 'INT_SP_SURF'
		);
		
		$data['services'][] = array(
			'text'  => $this->language->get('INT_TP'),
			'value' => 'INT_TP'
		);
		
		if (isset($this->request->post['shipping_hitcpost_weight'])) {
			$data['shipping_hitcpost_weight'] = $this->request->post['shipping_hitcpost_weight'];
		} else {
			$data['shipping_hitcpost_weight'] = $this->config->get('shipping_hitcpost_weight');
		}
		
		if (isset($this->request->post['shipping_hitcpost_packing_type'])) {
			$data['shipping_hitcpost_packing_type'] = $this->request->post['shipping_hitcpost_packing_type'];
		} else {
			$data['shipping_hitcpost_packing_type'] = $this->config->get('shipping_hitcpost_packing_type');
		}
		
		if (isset($this->request->post['shipping_hitcpost_per_item'])) {
			$data['shipping_hitcpost_per_item'] = $this->request->post['shipping_hitcpost_per_item'];
		} else {
			$data['shipping_hitcpost_per_item'] = $this->config->get('shipping_hitcpost_per_item');
		}
		
		
			
		if (isset($this->request->post['shipping_hitcpost_wight_b'])) {
			$data['shipping_hitcpost_wight_b'] = $this->request->post['shipping_hitcpost_wight_b'];
		} else {
			$data['shipping_hitcpost_wight_b'] = $this->config->get('shipping_hitcpost_wight_b');
		}
		
				
		if (isset($this->request->post['shipping_hitcpost_weight_c'])) {
			$data['shipping_hitcpost_weight_c'] = $this->request->post['shipping_hitcpost_weight_c'];
		} else {
			$data['shipping_hitcpost_weight_c'] = $this->config->get('shipping_hitcpost_weight_c');
		}
		
				
		if (isset($this->request->post['shipping_hitcpost_plt'])) {
			$data['shipping_hitcpost_plt'] = $this->request->post['shipping_hitcpost_plt'];
		} else {
			$data['shipping_hitcpost_plt'] = $this->config->get('shipping_hitcpost_plt');
		}
		
				
		if (isset($this->request->post['shipping_hitcpost_sat'])) {
			$data['shipping_hitcpost_sat'] = $this->request->post['shipping_hitcpost_sat'];
		} else {
			$data['shipping_hitcpost_sat'] = $this->config->get('shipping_hitcpost_sat');
		}
		
				
		if (isset($this->request->post['shipping_hitcpost_email_trach'])) {
			$data['shipping_hitcpost_email_trach'] = $this->request->post['shipping_hitcpost_email_trach'];
		} else {
			$data['shipping_hitcpost_email_trach'] = $this->config->get('shipping_hitcpost_email_trach');
		}
				
		if (isset($this->request->post['shipping_hitcpost_airway'])) {
			$data['shipping_hitcpost_airway'] = $this->request->post['shipping_hitcpost_airway'];
		} else {
			$data['shipping_hitcpost_airway'] = $this->config->get('shipping_hitcpost_airway');
		}
				
		if (isset($this->request->post['shipping_hitcpost_dropoff_type'])) {
			$data['shipping_hitcpost_dropoff_type'] = $this->request->post['shipping_hitcpost_dropoff_type'];
		} else {
			$data['shipping_hitcpost_dropoff_type'] = $this->config->get('shipping_hitcpost_dropoff_type');
		}
				
		if (isset($this->request->post['shipping_hitcpost_duty_type'])) {
			$data['shipping_hitcpost_duty_type'] = $this->request->post['shipping_hitcpost_duty_type'];
		} else {
			$data['shipping_hitcpost_duty_type'] = $this->config->get('shipping_hitcpost_duty_type');
		}
		if (isset($this->request->post['shipping_hitcpost_output_type'])) {
			$data['shipping_hitcpost_output_type'] = $this->request->post['shipping_hitcpost_output_type'];
		} else {
			$data['shipping_hitcpost_output_type'] = $this->config->get('shipping_hitcpost_output_type');
		}
		if (isset($this->request->post['shipping_hitcpost_export_reason'])) {
			$data['shipping_hitcpost_export_reason'] = $this->request->post['shipping_hitcpost_export_reason'];
		} else {
			$data['shipping_hitcpost_export_reason'] = $this->config->get('shipping_hitcpost_export_reason');
		}
		if (isset($this->request->post['shipping_hitcpost_customs_des'])) {
			$data['shipping_hitcpost_customs_des'] = $this->request->post['shipping_hitcpost_customs_des'];
		} else {
			$data['shipping_hitcpost_customs_des'] = $this->config->get('shipping_hitcpost_customs_des');
		}

		if (isset($this->request->post['shipping_hitcpost_shipment_content'])) {
			$data['shipping_hitcpost_shipment_content'] = $this->request->post['shipping_hitcpost_shipment_content'];
		} else {
			$data['shipping_hitcpost_shipment_content'] = $this->config->get('shipping_hitcpost_shipment_content');
		}
		if (isset($this->request->post['shipping_hitcpost_logo'])) {
			$data['shipping_hitcpost_logo'] = $this->request->post['shipping_hitcpost_logo'];
		} else {
			$data['shipping_hitcpost_logo'] = $this->config->get('shipping_hitcpost_logo');
		}
		
		if (isset($this->request->post['shipping_hitcpost_picbussiness'])) {
			$data['shipping_hitcpost_picbussiness'] = $this->request->post['shipping_hitcpost_picbussiness'];
		} else {
			$data['shipping_hitcpost_picbussiness'] = $this->config->get('shipping_hitcpost_picbussiness');
		}
		if (isset($this->request->post['shipping_hitcpost_picalt_company'])) {
			$data['shipping_hitcpost_picalt_company'] = $this->request->post['shipping_hitcpost_picalt_company'];
		} else {
			$data['shipping_hitcpost_picalt_company'] = $this->config->get('shipping_hitcpost_picalt_company');
		}
		if (isset($this->request->post['shipping_hitcpost_picalt_address'])) {
			$data['shipping_hitcpost_picalt_address'] = $this->request->post['shipping_hitcpost_picalt_address'];
		} else {
			$data['shipping_hitcpost_picalt_address'] = $this->config->get('shipping_hitcpost_picalt_address');
		}
				if (isset($this->request->post['shipping_hitcpost_picalt_city'])) {
			$data['shipping_hitcpost_picalt_city'] = $this->request->post['shipping_hitcpost_picalt_city'];
		} else {
			$data['shipping_hitcpost_picalt_city'] = $this->config->get('shipping_hitcpost_picalt_city');
		}
				if (isset($this->request->post['shipping_hitcpost_picalt_province'])) {
			$data['shipping_hitcpost_picalt_province'] = $this->request->post['shipping_hitcpost_picalt_province'];
		} else {
			$data['shipping_hitcpost_picalt_province'] = $this->config->get('shipping_hitcpost_picalt_province');
		}
				if (isset($this->request->post['shipping_hitcpost_picalt_post_code'])) {
			$data['shipping_hitcpost_picalt_post_code'] = $this->request->post['shipping_hitcpost_picalt_post_code'];
		} else {
			$data['shipping_hitcpost_picalt_post_code'] = $this->config->get('shipping_hitcpost_picalt_post_code');
		}

		if (isset($this->request->post['shipping_hitcpost_picper'])) {
			$data['shipping_hitcpost_picper'] = $this->request->post['shipping_hitcpost_picper'];
		} else {
			$data['shipping_hitcpost_picper'] = $this->config->get('shipping_hitcpost_picper');
		}
		if (isset($this->request->post['shipping_hitcpost_picper_email'])) {
			$data['shipping_hitcpost_picper_email'] = $this->request->post['shipping_hitcpost_picper_email'];
		} else {
			$data['shipping_hitcpost_picper_email'] = $this->config->get('shipping_hitcpost_picper_email');
		}
			if (isset($this->request->post['shipping_hitcpost_piccon'])) {
			$data['shipping_hitcpost_piccon'] = $this->request->post['shipping_hitcpost_piccon'];
		} else {
			$data['shipping_hitcpost_piccon'] = $this->config->get('shipping_hitcpost_piccon');
		}
		if (isset($this->request->post['shipping_hitcpost_picfiveton'])) {
			$data['shipping_hitcpost_picfiveton'] = $this->request->post['shipping_hitcpost_picfiveton'];
		} else {
			$data['shipping_hitcpost_picfiveton'] = $this->config->get('shipping_hitcpost_picfiveton');
		}
		if (isset($this->request->post['shipping_hitcpost_picloading_dock'])) {
			$data['shipping_hitcpost_picloading_dock'] = $this->request->post['shipping_hitcpost_picloading_dock'];
		} else {
			$data['shipping_hitcpost_picloading_dock'] = $this->config->get('shipping_hitcpost_picloading_dock');
		}
		if (isset($this->request->post['shipping_hitcpost_picinstructions'])) {
			$data['shipping_hitcpost_picinstructions'] = $this->request->post['shipping_hitcpost_picinstructions'];
		} else {
			$data['shipping_hitcpost_picinstructions'] = $this->config->get('shipping_hitcpost_picinstructions');
		}
		if (isset($this->request->post['shipping_hitcpost_picpww'])) {
			$data['shipping_hitcpost_picpww'] = $this->request->post['shipping_hitcpost_picpww'];
		} else {
			$data['shipping_hitcpost_picpww'] = $this->config->get('shipping_hitcpost_picpww');
		}
		if (isset($this->request->post['shipping_hitcpost_picpriority'])) {
			$data['shipping_hitcpost_picpriority'] = $this->request->post['shipping_hitcpost_picpriority'];
		} else {
			$data['shipping_hitcpost_picpriority'] = $this->config->get('shipping_hitcpost_picpriority');
		}
		if (isset($this->request->post['shipping_hitcpost_picreturns'])) {
			$data['shipping_hitcpost_picreturns'] = $this->request->post['shipping_hitcpost_picreturns'];
		} else {
			$data['shipping_hitcpost_picreturns'] = $this->config->get('shipping_hitcpost_picreturns');
		}
		if (isset($this->request->post['shipping_hitcpost_picheavy_item'])) {
			$data['shipping_hitcpost_picheavy_item'] = $this->request->post['shipping_hitcpost_picheavy_item'];
		} else {
			$data['shipping_hitcpost_picheavy_item'] = $this->config->get('shipping_hitcpost_picheavy_item');
		}
			if (isset($this->request->post['shipping_hitcpost_pickup_time'])) {
			$data['shipping_hitcpost_pickup_time'] = $this->request->post['shipping_hitcpost_pickup_time'];
		} else {
			$data['shipping_hitcpost_pickup_time'] = $this->config->get('shipping_hitcpost_pickup_time');
		}
			if (isset($this->request->post['shipping_hitcpost_close_time'])) {
			$data['shipping_hitcpost_close_time'] = $this->request->post['shipping_hitcpost_close_time'];
		} else {
			$data['shipping_hitcpost_close_time'] = $this->config->get('shipping_hitcpost_close_time');
		}

		//licence
		if (isset($this->request->post['shipping_hitcpost_licence_licence'])) {
			$data['shipping_hitcpost_licence_licence'] = $this->request->post['shipping_hitcpost_licence_licence'];
		} else {
			$data['shipping_hitcpost_licence_licence'] = $this->config->get('shipping_hitcpost_licence_licence');
		}
		if (isset($this->request->post['shipping_hitcpost_licence_email'])) {
			$data['shipping_hitcpost_licence_email'] = $this->request->post['shipping_hitcpost_licence_email'];
		} else {
			$data['shipping_hitcpost_licence_email'] = $this->config->get('shipping_hitcpost_licence_email');
		}
		if (isset($this->request->post['shipping_hitcpost_licence_expires'])) {
			$data['shipping_hitcpost_licence_expires'] = $this->request->post['shipping_hitcpost_licence_expires'];
		} else {
			$data['shipping_hitcpost_licence_expires'] = $this->config->get('shipping_hitcpost_licence_expires');
		}
		if (isset($this->request->post['shipping_hitcpost_licence_status_licence'])) {
			$data['shipping_hitcpost_licence_status_licence'] = $this->request->post['shipping_hitcpost_licence_status_licence'];
		} else {
			$data['shipping_hitcpost_licence_status_licence'] = $this->config->get('shipping_hitcpost_licence_status_licence');
		}
		
		//renew 
		if (isset($this->request->post['shipping_hitcpost_renew_expires'])) {
			$data['shipping_hitcpost_renew_expires'] = $this->request->post['shipping_hitcpost_renew_expires'];
		} else {
			$data['shipping_hitcpost_renew_expires'] = $this->config->get('shipping_hitcpost_renew_expires');
		}

		if($data['shipping_hitcpost_licence_expires'])
		{
			$curdate=strtotime(date('d-m-Y',strtotime('now')));
			$expire_date=strtotime( date('d-m-Y', strtotime($data['shipping_hitcpost_licence_expires']) ) );
			if($expire_date < $curdate)
			{
				if($data['shipping_hitcpost_renew_expires'])
				{
					$expire_date = $expire_date=strtotime( date('d-m-Y', strtotime($data['shipping_hitcpost_renew_expires']) ) );
					if($expire_date < $curdate)
					{
						$data['shipping_hitcpost_renew_status_licence'] = 'Expired';
					}
				}else
				{
					$data['shipping_hitcpost_renew_status_licence'] = 'Expired';
				}			
			}
			$data['shipping_hitcpost_licence_expires'] = date('D-M-Y',$expire_date);

		}

		//thilak
		
		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');
		
		$this->response->setOutput($this->load->view('extension/shipping/hitcpost', $data));
	}
	
	protected function validate() {
		if (!$this->user->hasPermission('modify', 'extension/shipping/hitcpost')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		if (!$this->request->post['shipping_hitcpost_username']) {
			$this->error['name'] = $this->language->get('error_name');
		}

		if (!$this->request->post['shipping_hitcpost_password']) {
			$this->error['password'] = $this->language->get('error_password');
		}

		if (!$this->request->post['shipping_hitcpost_customer_num']) {
			$this->error['customer'] = $this->language->get('error_customer');
		}

		if (!$this->request->post['shipping_hitcpost_postcode']) {
			$this->error['postcode'] = $this->language->get('error_postcode');
		}

		return !$this->error;
	}
}
