<?php
class ControllerSaleCannedMessage extends Controller { 
	private $error = array();
	
	protected function CannedMessagedbCheck(){
		$query = $this->db->query("SHOW TABLES LIKE '".DB_PREFIX."cannedmessage'");
			if(!$query->num_rows){
				$this->db->query("CREATE TABLE `".DB_PREFIX."cannedmessage` (
				  `cannedmessage_id` int(11) NOT NULL AUTO_INCREMENT,
				  `sort_order` int(3) NOT NULL DEFAULT '0',
				  `status` tinyint(1) NOT NULL DEFAULT '1',
				  `title` varchar(64) COLLATE utf8_bin NOT NULL DEFAULT '',
				  `description` text COLLATE utf8_bin NOT NULL,
				  PRIMARY KEY (`cannedmessage_id`)
				) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_bin;");
			}
	}
	
	public function index() {
		$this->CannedMessagedbCheck();
		$this->load->language('sale/cannedmessage');

		$this->document->setTitle($this->language->get('heading_title'));
		 
		$this->load->model('sale/cannedmessage');

		$this->getList();
	}
	
	public function insert() {
		$this->load->language('sale/cannedmessage');

		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('sale/cannedmessage');
				
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
			$this->model_sale_cannedmessage->addCannedMessage($this->request->post);
			
			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';
			
			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}
			
			$this->response->redirect($this->url->link('sale/cannedmessage', 'token=' . $this->session->data['token'] . $url, true));
		}

		$this->getForm();
	}

	public function update() {
		$this->load->language('sale/cannedmessage');

		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('sale/cannedmessage');
		
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
			$this->model_sale_cannedmessage->editCannedMessage($this->request->get['cannedmessage_id'], $this->request->post);
			
			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';
			
			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}
			
			$this->response->redirect($this->url->link('sale/cannedmessage', 'token=' . $this->session->data['token'] . $url, true));
		}

		$this->getForm();
	}
 
	public function delete() {
		$this->load->language('sale/cannedmessage');

		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('sale/cannedmessage');
		
		if (isset($this->request->post['selected']) && $this->validateDelete()) {
			foreach ($this->request->post['selected'] as $cannedmessage_id) {
				$this->model_sale_cannedmessage->deleteCannedMessage($cannedmessage_id);
			}
			
			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';
			
			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}
			
			$this->response->redirect($this->url->link('sale/cannedmessage', 'token=' . $this->session->data['token'] . $url, true));
		}

		$this->getList();
	}

	private function getList() {
		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'id.title';
		}
		
		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'ASC';
		}
		
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
		
		$url = '';
			
		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
		
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

  		$data['breadcrumbs'] = array();

   		$data['breadcrumbs'][] = array(
       		'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'token=' . $this->session->data['token'], true)
   		);

   		$data['breadcrumbs'][] = array(
       		'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('sale/cannedmessage', 'token=' . $this->session->data['token'] . $url, true)
   		);
							
		$data['insert'] = $this->url->link('sale/cannedmessage/insert', 'token=' . $this->session->data['token'] . $url, true);
		$data['delete'] = $this->url->link('sale/cannedmessage/delete', 'token=' . $this->session->data['token'] . $url, true);	

		$data['cannedmessages'] = array();

		$filter_data = array(
			'sort'  => $sort,
			'order' => $order,
			'start' => ($page - 1) * $this->config->get('config_limit_admin'),
			'limit' => $this->config->get('config_limit_admin')
		);
		
		$CannedMessage_total = $this->model_sale_cannedmessage->getTotalCannedMessages();
	
		$results = $this->model_sale_cannedmessage->getCannedMessages($filter_data);
 
    	foreach ($results as $result) {
			$action = array();
						
			$action[] = array(
				'text' => $this->language->get('text_edit'),
				'href' => $this->url->link('sale/cannedmessage/update', 'token=' . $this->session->data['token'] . '&cannedmessage_id=' . $result['cannedmessage_id'] . $url, true)
			);
						
			$data['cannedmessages'][] = array(
				'cannedmessage_id' => $result['cannedmessage_id'],
				'title'          => $result['title'],
				'sort_order'     => $result['sort_order'],
				'selected'       => isset($this->request->post['selected']) && in_array($result['cannedmessage_id'], $this->request->post['selected']),
				'action'         => $action
			);
		}	
	
		$data['heading_title'] = $this->language->get('heading_title');

		$data['text_no_results'] = $this->language->get('text_no_results');

		$data['column_title'] = $this->language->get('column_title');
		$data['column_sort_order'] = $this->language->get('column_sort_order');
		$data['column_action'] = $this->language->get('column_action');		
		
		$data['text_confirm'] = $this->language->get('text_confirm');
		$data['text_add'] = $this->language->get('text_add');
		
		$data['button_insert'] = $this->language->get('button_insert');
		$data['button_delete'] = $this->language->get('button_delete');
 
 		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}
		
		if (isset($this->session->data['success'])) {
			$data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$data['success'] = '';
		}

		$url = '';

		if ($order == 'ASC') {
			$url .= '&order=DESC';
		} else {
			$url .= '&order=ASC';
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		
		$data['sort_title'] = $this->url->link('sale/cannedmessage', 'token=' . $this->session->data['token'] . '&sort=id.title' . $url, true);
		$data['sort_sort_order'] = $this->url->link('sale/cannedmessage', 'token=' . $this->session->data['token'] . '&sort=i.sort_order' . $url, true);
		
		$url = '';

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}
												
		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		$pagination = new Pagination();
		$pagination->total = $CannedMessage_total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_limit_admin');
		$pagination->url = $this->url->link('sale/cannedmessage', 'token=' . $this->session->data['token'] . $url . '&page={page}', true);
			
		$data['pagination'] = $pagination->render();

		$data['results'] = sprintf($this->language->get('text_pagination'), ($CannedMessage_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($CannedMessage_total - $this->config->get('config_limit_admin'))) ? $CannedMessage_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $CannedMessage_total, ceil($CannedMessage_total / $this->config->get('config_limit_admin')));

		$data['sort'] = $sort;
		$data['order'] = $order;
	
		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('sale/cannedmessage_list', $data));
	}

	private function getForm() {
		$data['heading_title'] = $this->language->get('heading_title');

		$data['text_default'] = $this->language->get('text_default');
		$data['text_enabled'] = $this->language->get('text_enabled');
    	$data['text_disabled'] = $this->language->get('text_disabled');
		
		$data['entry_title'] = $this->language->get('entry_title');
		$data['entry_description'] = $this->language->get('entry_description');
		$data['help_description'] = $this->language->get('help_description');
		$data['entry_sort_order'] = $this->language->get('entry_sort_order');
		$data['entry_status'] = $this->language->get('entry_status');
		
		$data['button_save'] = $this->language->get('button_save');
		$data['button_cancel'] = $this->language->get('button_cancel');
    	
		

 		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

 		if (isset($this->error['cannedmessage_title'])) {
			$data['error_cannedmessage_title'] = $this->error['cannedmessage_title'];
		} else {
			$data['error_cannedmessage_title'] = '';
		}
		
	 	if (isset($this->error['description'])) {
			$data['error_description'] = $this->error['description'];
		} else {
			$data['error_description'] = '';
		}
		
		$url = '';
			
		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
		
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		
  		$data['breadcrumbs'] = array();

   		$data['breadcrumbs'][] = array(
       		'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'token=' . $this->session->data['token'], true)
   		);

   		$data['breadcrumbs'][] = array(
       		'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('sale/cannedmessage', 'token=' . $this->session->data['token'] . $url, true)
   		);
							
		if (!isset($this->request->get['cannedmessage_id'])) {
			$data['action'] = $this->url->link('sale/cannedmessage/insert', 'token=' . $this->session->data['token'] . $url, true);
		} else {
			$data['action'] = $this->url->link('sale/cannedmessage/update', 'token=' . $this->session->data['token'] . '&cannedmessage_id=' . $this->request->get['cannedmessage_id'] . $url, true);
		}
		
		$data['cancel'] = $this->url->link('sale/cannedmessage', 'token=' . $this->session->data['token'] . $url, true);

		if (isset($this->request->get['cannedmessage_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
			$cannedmessage_info = $this->model_sale_cannedmessage->getCannedMessage($this->request->get['cannedmessage_id']);
		}
		
		$data['token'] = $this->session->data['token'];
		
		$this->load->model('localisation/language');

		$data['languages'] = $this->model_localisation_language->getLanguages();

		if (isset($this->request->post['cannedmessage_description'])) {
			$data['cannedmessage_description'] = $this->request->post['cannedmessage_description'];
		} elseif (!empty($cannedmessage_info)) {
			$data['cannedmessage_description'] = $cannedmessage_info['description'];
		} else {
			$data['cannedmessage_description'] = '';
		}

		if (isset($this->request->post['cannedmessage_title'])) {
			$data['cannedmessage_title'] = $this->request->post['cannedmessage_title'];
		} elseif (!empty($cannedmessage_info)) {
			$data['cannedmessage_title'] = $cannedmessage_info['title'];
		} else {
			$data['cannedmessage_title'] = '';
		}

	
			
		if (isset($this->request->post['status'])) {
			$data['status'] = $this->request->post['status'];
		} elseif (!empty($cannedmessage_info)) {
			$data['status'] = $cannedmessage_info['status'];
		} else {
			$data['status'] = 1;
		}
				
		if (isset($this->request->post['sort_order'])) {
			$data['sort_order'] = $this->request->post['sort_order'];
		} elseif (!empty($cannedmessage_info)) {
			$data['sort_order'] = $cannedmessage_info['sort_order'];
		} else {
			$data['sort_order'] = '';
		}
		
		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('sale/cannedmessage_form', $data));
	}

	protected function validateForm() {
		if (!$this->user->hasPermission('modify', 'sale/cannedmessage')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		if ((utf8_strlen($this->request->post['cannedmessage_title']) < 3) || (utf8_strlen($this->request->post['cannedmessage_title']) > 64)) {
			$this->error['cannedmessage_title'] = $this->language->get('error_cannedmessage_title');
		}
		
		if (utf8_strlen($this->request->post['cannedmessage_description']) < 3) {
			$this->error['description'] = $this->language->get('error_description');
		}

		if ($this->error && !isset($this->error['warning'])) {
			$this->error['warning'] = $this->language->get('error_warning');
		}
			
		return !$this->error;
	}

	protected function validateDelete() {
		if (!$this->user->hasPermission('modify', 'sale/cannedmessage')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		$this->load->model('setting/store');
		
		return !$this->error;
	}
}
?>