<?php
class ControllerExtensionShippinghitshipocpost extends Controller {
	private $error = array();
	public function install() {
		$this->db->query("CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . "hitshipo_cpost_details_new` (
		  `id` int(11) NOT NULL AUTO_INCREMENT,
		  `order_id` text NOT NULL,
		  `shipment_id` text NOT NULL,
		  `tracking_num` text NOT NULL,
		  `shipping_label` text COLLATE utf8_bin NOT NULL,
		  `invoice` text COLLATE utf8_bin NOT NULL,
		  `return_label` text COLLATE utf8_bin  NULL,
		  `return_invoice` text COLLATE utf8_bin  NULL,
		  `one` text COLLATE utf8_bin  NULL,
		  `two` text COLLATE utf8_bin  NULL,
		  `three` text COLLATE utf8_bin  NULL,
		  PRIMARY KEY (`id`)
		)");
	}
	public function index() {
		$this->install();
		$this->load->language('extension/shipping/hitshipo_cpost');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('setting/setting');
		
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {

			$this->model_setting_setting->editSetting('shipping_hitshipo_cpost', $this->request->post);
// echo '<pre>';
// print_r($this->model_setting_setting->getSetting('shipping_hitshipo_cpost'));
// die();
			$this->session->data['success'] = $this->language->get('text_success');

			$this->response->redirect($this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=shipping', true));

		}


		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}
		
		if (isset($this->error['name'])) {
			$data['error_name'] = $this->error['name'];
		} else {
			$data['error_name'] = '';
		}

		if (isset($this->error['password'])) {
			$data['error_password'] = $this->error['password'];
		} else {
			$data['error_password'] = '';
		}

		if (isset($this->error['customer'])) {
			$data['error_customer'] = $this->error['customer'];
		} else {
			$data['error_customer'] = '';
		}

		// if (isset($this->error['contract'])) {
		// 	$data['error_contract'] = $this->error['contract'];
		// } else {
		// 	$data['error_contract'] = '';
		// }
		
		if (isset($this->error['postcode'])) {
			$data['error_postcode'] = $this->error['postcode'];
		} else {
			$data['error_postcode'] = '';
		}

		if (isset($this->error['dimension'])) {
			$data['error_dimension'] = $this->error['dimension'];
		} else {
			$data['error_dimension'] = '';
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_extension'),
			'href' => $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=shipping', true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('extension/shipping/hitshipo_cpost', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['action'] = $this->url->link('extension/shipping/hitshipo_cpost', 'user_token=' . $this->session->data['user_token'], true);

		$data['cancel'] = $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=shipping', true);

		
		if (isset($this->request->post['shipping_hitshipo_cpost_test'])) {
			$data['shipping_hitshipo_cpost_test'] = $this->request->post['shipping_hitshipo_cpost_test'];
		} else {
			$data['shipping_hitshipo_cpost_test'] = $this->config->get('shipping_hitshipo_cpost_test');
		}
		
		if (isset($this->request->post['shipping_hitshipo_cpost_username'])) {
			$data['shipping_hitshipo_cpost_username'] = $this->request->post['shipping_hitshipo_cpost_username'];
		} else {
			$data['shipping_hitshipo_cpost_username'] = $this->config->get('shipping_hitshipo_cpost_username');
		}

		if (isset($this->request->post['shipping_hitshipo_cpost_password'])) {
			$data['shipping_hitshipo_cpost_password'] = $this->request->post['shipping_hitshipo_cpost_password'];
		} else {
			$data['shipping_hitshipo_cpost_password'] = $this->config->get('shipping_hitshipo_cpost_password');
		}

		if (isset($this->request->post['shipping_hitshipo_cpost_customer_num'])) {
			$data['shipping_hitshipo_cpost_customer_num'] = $this->request->post['shipping_hitshipo_cpost_customer_num'];
		} else {
			$data['shipping_hitshipo_cpost_customer_num'] = $this->config->get('shipping_hitshipo_cpost_customer_num');
		}

		if (isset($this->request->post['shipping_hitshipo_cpost_contract_id'])) {
			$data['shipping_hitshipo_cpost_contract_id'] = $this->request->post['shipping_hitshipo_cpost_contract_id'];
		} else {
			$data['shipping_hitshipo_cpost_contract_id'] = $this->config->get('shipping_hitshipo_cpost_contract_id');
		}
		
		if (isset($this->request->post['shipping_hitshipo_cpost_status'])) {
			$data['shipping_hitshipo_cpost_status'] = $this->request->post['shipping_hitshipo_cpost_status'];
		} else {
			$data['shipping_hitshipo_cpost_status'] = $this->config->get('shipping_hitshipo_cpost_status');
		}

		if (isset($this->request->post['shipping_hitshipo_cpost_sort_order'])) {
			$data['shipping_hitshipo_cpost_sort_order'] = $this->request->post['shipping_hitshipo_cpost_sort_order'];
		} else {
			$data['shipping_hitshipo_cpost_sort_order'] = $this->config->get('shipping_hitshipo_cpost_sort_order');
		}

		if (isset($this->request->post['shipping_hitshipo_cpost_shipper_name'])) {
			$data['shipping_hitshipo_cpost_shipper_name'] = $this->request->post['shipping_hitshipo_cpost_shipper_name'];
		} else {
			$data['shipping_hitshipo_cpost_shipper_name'] = $this->config->get('shipping_hitshipo_cpost_shipper_name');
		}
		
		if (isset($this->request->post['shipping_hitshipo_cpost_company_name'])) {
			$data['shipping_hitshipo_cpost_company_name'] = $this->request->post['shipping_hitshipo_cpost_company_name'];
		} else {
			$data['shipping_hitshipo_cpost_company_name'] = $this->config->get('shipping_hitshipo_cpost_company_name');
		}
		
		if (isset($this->request->post['shipping_hitshipo_cpost_phone_num'])) {
			$data['shipping_hitshipo_cpost_phone_num'] = $this->request->post['shipping_hitshipo_cpost_phone_num'];
		} else {
			$data['shipping_hitshipo_cpost_phone_num'] = $this->config->get('shipping_hitshipo_cpost_phone_num');
		}
		
		if (isset($this->request->post['shipping_hitshipo_cpost_email_addr'])) {
			$data['shipping_hitshipo_cpost_email_addr'] = $this->request->post['shipping_hitshipo_cpost_email_addr'];
		} else {
			$data['shipping_hitshipo_cpost_email_addr'] = $this->config->get('shipping_hitshipo_cpost_email_addr');
		}
		
		if (isset($this->request->post['shipping_hitshipo_cpost_address1'])) {
			$data['shipping_hitshipo_cpost_address1'] = $this->request->post['shipping_hitshipo_cpost_address1'];
		} else {
			$data['shipping_hitshipo_cpost_address1'] = $this->config->get('shipping_hitshipo_cpost_address1');
		}
		
		if (isset($this->request->post['shipping_hitshipo_cpost_address2'])) {
			$data['shipping_hitshipo_cpost_address2'] = $this->request->post['shipping_hitshipo_cpost_address2'];
		} else {
			$data['shipping_hitshipo_cpost_address2'] = $this->config->get('shipping_hitshipo_cpost_address2');
		}
		
		
		if (isset($this->request->post['shipping_hitshipo_cpost_city'])) {
			$data['shipping_hitshipo_cpost_city'] = $this->request->post['shipping_hitshipo_cpost_city'];
		} else {
			$data['shipping_hitshipo_cpost_city'] = $this->config->get('shipping_hitshipo_cpost_city');
		}
		
		
		if (isset($this->request->post['shipping_hitshipo_cpost_state'])) {
			$data['shipping_hitshipo_cpost_state'] = $this->request->post['shipping_hitshipo_cpost_state'];
		} else {
			$data['shipping_hitshipo_cpost_state'] = $this->config->get('shipping_hitshipo_cpost_state');
		}
		
		
		if (isset($this->request->post['shipping_hitshipo_cpost_country_code'])) {
			$data['shipping_hitshipo_cpost_country_code'] = $this->request->post['shipping_hitshipo_cpost_country_code'];
		} else {
			$data['shipping_hitshipo_cpost_country_code'] = $this->config->get('shipping_hitshipo_cpost_country_code');
		}
		$data['countrylist'] = array(
			'AF' => 'Afghanistan',
			'AX' => 'Aland Islands',
			'AL' => 'Albania',
			'DZ' => 'Algeria',
			'AS' => 'American Samoa',
			'AD' => 'Andorra',
			'AO' => 'Angola',
			'AI' => 'Anguilla',
			'AQ' => 'Antarctica',
			'AG' => 'Antigua and Barbuda',
			'AR' => 'Argentina',
			'AM' => 'Armenia',
			'AW' => 'Aruba',
			'AU' => 'Australia',
			'AT' => 'Austria',
			'AZ' => 'Azerbaijan',
			'BS' => 'Bahamas',
			'BH' => 'Bahrain',
			'BD' => 'Bangladesh',
			'BB' => 'Barbados',
			'BY' => 'Belarus',
			'BE' => 'Belgium',
			'BZ' => 'Belize',
			'BJ' => 'Benin',
			'BM' => 'Bermuda',
			'BT' => 'Bhutan',
			'BO' => 'Bolivia',
			'BQ' => 'Bonaire, Saint Eustatius and Saba',
			'BA' => 'Bosnia and Herzegovina',
			'BW' => 'Botswana',
			'BV' => 'Bouvet Island',
			'BR' => 'Brazil',
			'IO' => 'British Indian Ocean Territory',
			'VG' => 'British Virgin Islands',
			'BN' => 'Brunei',
			'BG' => 'Bulgaria',
			'BF' => 'Burkina Faso',
			'BI' => 'Burundi',
			'KH' => 'Cambodia',
			'CM' => 'Cameroon',
			'CA' => 'Canada',
			'CV' => 'Cape Verde',
			'KY' => 'Cayman Islands',
			'CF' => 'Central African Republic',
			'TD' => 'Chad',
			'CL' => 'Chile',
			'CN' => 'China',
			'CX' => 'Christmas Island',
			'CC' => 'Cocos Islands',
			'CO' => 'Colombia',
			'KM' => 'Comoros',
			'CK' => 'Cook Islands',
			'CR' => 'Costa Rica',
			'HR' => 'Croatia',
			'CU' => 'Cuba',
			'CW' => 'Curacao',
			'CY' => 'Cyprus',
			'CZ' => 'Czech Republic',
			'CD' => 'Democratic Republic of the Congo',
			'DK' => 'Denmark',
			'DJ' => 'Djibouti',
			'DM' => 'Dominica',
			'DO' => 'Dominican Republic',
			'TL' => 'East Timor',
			'EC' => 'Ecuador',
			'EG' => 'Egypt',
			'SV' => 'El Salvador',
			'GQ' => 'Equatorial Guinea',
			'ER' => 'Eritrea',
			'EE' => 'Estonia',
			'ET' => 'Ethiopia',
			'FK' => 'Falkland Islands',
			'FO' => 'Faroe Islands',
			'FJ' => 'Fiji',
			'FI' => 'Finland',
			'FR' => 'France',
			'GF' => 'French Guiana',
			'PF' => 'French Polynesia',
			'TF' => 'French Southern Territories',
			'GA' => 'Gabon',
			'GM' => 'Gambia',
			'GE' => 'Georgia',
			'DE' => 'Germany',
			'GH' => 'Ghana',
			'GI' => 'Gibraltar',
			'GR' => 'Greece',
			'GL' => 'Greenland',
			'GD' => 'Grenada',
			'GP' => 'Guadeloupe',
			'GU' => 'Guam',
			'GT' => 'Guatemala',
			'GG' => 'Guernsey',
			'GN' => 'Guinea',
			'GW' => 'Guinea-Bissau',
			'GY' => 'Guyana',
			'HT' => 'Haiti',
			'HM' => 'Heard Island and McDonald Islands',
			'HN' => 'Honduras',
			'HK' => 'Hong Kong',
			'HU' => 'Hungary',
			'IS' => 'Iceland',
			'IN' => 'India',
			'ID' => 'Indonesia',
			'IR' => 'Iran',
			'IQ' => 'Iraq',
			'IE' => 'Ireland',
			'IM' => 'Isle of Man',
			'IL' => 'Israel',
			'IT' => 'Italy',
			'CI' => 'Ivory Coast',
			'JM' => 'Jamaica',
			'JP' => 'Japan',
			'JE' => 'Jersey',
			'JO' => 'Jordan',
			'KZ' => 'Kazakhstan',
			'KE' => 'Kenya',
			'KI' => 'Kiribati',
			'XK' => 'Kosovo',
			'KW' => 'Kuwait',
			'KG' => 'Kyrgyzstan',
			'LA' => 'Laos',
			'LV' => 'Latvia',
			'LB' => 'Lebanon',
			'LS' => 'Lesotho',
			'LR' => 'Liberia',
			'LY' => 'Libya',
			'LI' => 'Liechtenstein',
			'LT' => 'Lithuania',
			'LU' => 'Luxembourg',
			'MO' => 'Macao',
			'MK' => 'Macedonia',
			'MG' => 'Madagascar',
			'MW' => 'Malawi',
			'MY' => 'Malaysia',
			'MV' => 'Maldives',
			'ML' => 'Mali',
			'MT' => 'Malta',
			'MH' => 'Marshall Islands',
			'MQ' => 'Martinique',
			'MR' => 'Mauritania',
			'MU' => 'Mauritius',
			'YT' => 'Mayotte',
			'MX' => 'Mexico',
			'FM' => 'Micronesia',
			'MD' => 'Moldova',
			'MC' => 'Monaco',
			'MN' => 'Mongolia',
			'ME' => 'Montenegro',
			'MS' => 'Montserrat',
			'MA' => 'Morocco',
			'MZ' => 'Mozambique',
			'MM' => 'Myanmar',
			'NA' => 'Namibia',
			'NR' => 'Nauru',
			'NP' => 'Nepal',
			'NL' => 'Netherlands',
			'NC' => 'New Caledonia',
			'NZ' => 'New Zealand',
			'NI' => 'Nicaragua',
			'NE' => 'Niger',
			'NG' => 'Nigeria',
			'NU' => 'Niue',
			'NF' => 'Norfolk Island',
			'KP' => 'North Korea',
			'MP' => 'Northern Mariana Islands',
			'NO' => 'Norway',
			'OM' => 'Oman',
			'PK' => 'Pakistan',
			'PW' => 'Palau',
			'PS' => 'Palestinian Territory',
			'PA' => 'Panama',
			'PG' => 'Papua New Guinea',
			'PY' => 'Paraguay',
			'PE' => 'Peru',
			'PH' => 'Philippines',
			'PN' => 'Pitcairn',
			'PL' => 'Poland',
			'PT' => 'Portugal',
			'PR' => 'Puerto Rico',
			'QA' => 'Qatar',
			'CG' => 'Republic of the Congo',
			'RE' => 'Reunion',
			'RO' => 'Romania',
			'RU' => 'Russia',
			'RW' => 'Rwanda',
			'BL' => 'Saint Barthelemy',
			'SH' => 'Saint Helena',
			'KN' => 'Saint Kitts and Nevis',
			'LC' => 'Saint Lucia',
			'MF' => 'Saint Martin',
			'PM' => 'Saint Pierre and Miquelon',
			'VC' => 'Saint Vincent and the Grenadines',
			'WS' => 'Samoa',
			'SM' => 'San Marino',
			'ST' => 'Sao Tome and Principe',
			'SA' => 'Saudi Arabia',
			'SN' => 'Senegal',
			'RS' => 'Serbia',
			'SC' => 'Seychelles',
			'SL' => 'Sierra Leone',
			'SG' => 'Singapore',
			'SX' => 'Sint Maarten',
			'SK' => 'Slovakia',
			'SI' => 'Slovenia',
			'SB' => 'Solomon Islands',
			'SO' => 'Somalia',
			'ZA' => 'South Africa',
			'GS' => 'South Georgia and the South Sandwich Islands',
			'KR' => 'South Korea',
			'SS' => 'South Sudan',
			'ES' => 'Spain',
			'LK' => 'Sri Lanka',
			'SD' => 'Sudan',
			'SR' => 'Suriname',
			'SJ' => 'Svalbard and Jan Mayen',
			'SZ' => 'Swaziland',
			'SE' => 'Sweden',
			'CH' => 'Switzerland',
			'SY' => 'Syria',
			'TW' => 'Taiwan',
			'TJ' => 'Tajikistan',
			'TZ' => 'Tanzania',
			'TH' => 'Thailand',
			'TG' => 'Togo',
			'TK' => 'Tokelau',
			'TO' => 'Tonga',
			'TT' => 'Trinidad and Tobago',
			'TN' => 'Tunisia',
			'TR' => 'Turkey',
			'TM' => 'Turkmenistan',
			'TC' => 'Turks and Caicos Islands',
			'TV' => 'Tuvalu',
			'VI' => 'U.S. Virgin Islands',
			'UG' => 'Uganda',
			'UA' => 'Ukraine',
			'AE' => 'United Arab Emirates',
			'GB' => 'United Kingdom',
			'US' => 'United States',
			'UM' => 'United States Minor Outlying Islands',
			'UY' => 'Uruguay',
			'UZ' => 'Uzbekistan',
			'VU' => 'Vanuatu',
			'VA' => 'Vatican',
			'VE' => 'Venezuela',
			'VN' => 'Vietnam',
			'WF' => 'Wallis and Futuna',
			'EH' => 'Western Sahara',
			'YE' => 'Yemen',
			'ZM' => 'Zambia',
			'ZW' => 'Zimbabwe',
		);
		
		if (isset($this->request->post['shipping_hitshipo_cpost_postcode'])) {
			$data['shipping_hitshipo_cpost_postcode'] = $this->request->post['shipping_hitshipo_cpost_postcode'];
		} else {
			$data['shipping_hitshipo_cpost_postcode'] = $this->config->get('shipping_hitshipo_cpost_postcode');
		}
		
		if (isset($this->request->post['shipping_hitshipo_cpost_realtime_rates'])) {
			$data['shipping_hitshipo_cpost_realtime_rates'] = $this->request->post['shipping_hitshipo_cpost_realtime_rates'];
		} else {
			$data['shipping_hitshipo_cpost_realtime_rates'] = $this->config->get('shipping_hitshipo_cpost_realtime_rates');
		}
		if (isset($this->request->post['shipping_hitshipo_cpost_rate_tax'])) {
			$data['shipping_hitshipo_cpost_rate_tax'] = $this->request->post['shipping_hitshipo_cpost_rate_tax'];
		} else {
			$data['shipping_hitshipo_cpost_rate_tax'] = $this->config->get('shipping_hitshipo_cpost_rate_tax');
		}

		if (isset($this->request->post['shipping_hitshipo_cpost_front_end_logs'])) {
			$data['shipping_hitshipo_cpost_front_end_logs'] = $this->request->post['shipping_hitshipo_cpost_front_end_logs'];
		} else {
			$data['shipping_hitshipo_cpost_front_end_logs'] = $this->config->get('shipping_hitshipo_cpost_front_end_logs');
		}

		if (isset($this->request->post['shipping_hitshipo_cpost_back_end_logs'])) {
			$data['shipping_hitshipo_cpost_back_end_logs'] = $this->request->post['shipping_hitshipo_cpost_back_end_logs'];
		} else {
			$data['shipping_hitshipo_cpost_back_end_logs'] = $this->config->get('shipping_hitshipo_cpost_back_end_logs');
		}
			
		// if (isset($this->request->post['shipping_hitshipo_cpost_rate_type'])) {
		// 	$data['shipping_hitshipo_cpost_rate_type'] = $this->request->post['shipping_hitshipo_cpost_rate_type'];
		// } else {
		// 	$data['shipping_hitshipo_cpost_rate_type'] = $this->config->get('shipping_hitshipo_cpost_rate_type');
		// }
		
		
		if (isset($this->request->post['shipping_hitshipo_cpost_service'])) {
			$data['shipping_hitshipo_cpost_service'] = $this->request->post['shipping_hitshipo_cpost_service'];
		} elseif ($this->config->has('shipping_hitshipo_cpost_service')) {
			$data['shipping_hitshipo_cpost_service'] = $this->config->get('shipping_hitshipo_cpost_service');
		} else {
			$data['shipping_hitshipo_cpost_service'] = array();
		}

		$data['services'] = array();

		$data['services'][] = array(
			'text'  => $this->language->get('DOM_RP'),
			'value' => 'DOM_RP'
		);

		$data['services'][] = array(
			'text'  => $this->language->get('DOM_EP'),
			'value' => 'DOM_EP'
		);

		$data['services'][] = array(
			'text'  => $this->language->get('DOM_XP'),
			'value' => 'DOM_XP'
		);

		$data['services'][] = array(
			'text'  => $this->language->get('DOM_XP_CERT'),
			'value' => 'DOM_XP_CERT'
		);

		$data['services'][] = array(
			'text'  => $this->language->get('DOM_PC'),
			'value' => 'DOM_PC'
		);

		$data['services'][] = array(
			'text'  => $this->language->get('DOM_LIB'),
			'value' => 'DOM_LIB'
		);

		$data['services'][] = array(
			'text'  => $this->language->get('USA_EP'),
			'value' => 'USA_EP'
		);

		$data['services'][] = array(
			'text'  => $this->language->get('USA_PW_ENV'),
			'value' => 'USA_PW_ENV'
		);

		$data['services'][] = array(
			'text'  => $this->language->get('USA_PW_PAK'),
			'value' => 'USA_PW_PAK'
		);

		$data['services'][] = array(
			'text'  => $this->language->get('USA_PW_PARCEL'),
			'value' => 'USA_PW_PARCEL'
		);

		$data['services'][] = array(
			'text'  => $this->language->get('USA_SP_AIR'),
			'value' => 'USA_SP_AIR'
		);

		$data['services'][] = array(
			'text'  => $this->language->get('USA_TP'),
			'value' => 'USA_TP'
		);

		$data['services'][] = array(
			'text'  => $this->language->get('USA_XP'),
			'value' => 'USA_XP'
		);

		$data['services'][] = array(
			'text'  => $this->language->get('INT_XP'),
			'value' => 'INT_XP'
		);

		$data['services'][] = array(
			'text'  => $this->language->get('INT_IP_AIR'),
			'value' => 'INT_IP_AIR'
		);

		$data['services'][] = array(
			'text'  => $this->language->get('INT_IP_SURF'),
			'value' => 'INT_IP_SURF'
		);

		$data['services'][] = array(
			'text'  => $this->language->get('INT_PW_ENV'),
			'value' => 'INT_PW_ENV'
		);

		$data['services'][] = array(
			'text'  => $this->language->get('INT_PW_PAK'),
			'value' => 'INT_PW_PAK'
		);

		$data['services'][] = array(
			'text'  => $this->language->get('INT_PW_PARCEL'),
			'value' => 'INT_PW_PARCEL'
		);

		$data['services'][] = array(
			'text'  => $this->language->get('INT_SP_AIR'),
			'value' => 'INT_SP_AIR'
		);

		$data['services'][] = array(
			'text'  => $this->language->get('INT_SP_SURF'),
			'value' => 'INT_SP_SURF'
		);
		
		$data['services'][] = array(
			'text'  => $this->language->get('INT_TP'),
			'value' => 'INT_TP'
		);
		
		if (isset($this->request->post['shipping_hitshipo_cpost_weight'])) {
			$data['shipping_hitshipo_cpost_weight'] = $this->request->post['shipping_hitshipo_cpost_weight'];
		} else {
			$data['shipping_hitshipo_cpost_weight'] = $this->config->get('shipping_hitshipo_cpost_weight');
		}
		
		if (isset($this->request->post['shipping_hitshipo_cpost_packing_type'])) {
			$data['shipping_hitshipo_cpost_packing_type'] = $this->request->post['shipping_hitshipo_cpost_packing_type'];
		} else {
			$data['shipping_hitshipo_cpost_packing_type'] = $this->config->get('shipping_hitshipo_cpost_packing_type');
		}
		
		if (isset($this->request->post['shipping_hitshipo_cpost_per_item'])) {
			$data['shipping_hitshipo_cpost_per_item'] = $this->request->post['shipping_hitshipo_cpost_per_item'];
		} else {
			$data['shipping_hitshipo_cpost_per_item'] = $this->config->get('shipping_hitshipo_cpost_per_item');
		}
		
		
			
		if (isset($this->request->post['shipping_hitshipo_cpost_wight_b'])) {
			$data['shipping_hitshipo_cpost_wight_b'] = $this->request->post['shipping_hitshipo_cpost_wight_b'];
		} else {
			$data['shipping_hitshipo_cpost_wight_b'] = $this->config->get('shipping_hitshipo_cpost_wight_b');
		}
		
				
		if (isset($this->request->post['shipping_hitshipo_cpost_weight_c'])) {
			$data['shipping_hitshipo_cpost_weight_c'] = $this->request->post['shipping_hitshipo_cpost_weight_c'];
		} else {
			$data['shipping_hitshipo_cpost_weight_c'] = $this->config->get('shipping_hitshipo_cpost_weight_c');
		}
		
		if (isset($this->request->post['shipping_hitshipo_cpost_int_key'])) {
			$data['shipping_hitshipo_cpost_int_key'] = $this->request->post['shipping_hitshipo_cpost_int_key'];
		} else {
			$data['shipping_hitshipo_cpost_int_key'] = $this->config->get('shipping_hitshipo_cpost_int_key');
		}

		if (isset($this->request->post['shipping_hitshipo_cpost_auto_label'])) {
			$data['shipping_hitshipo_cpost_auto_label'] = $this->request->post['shipping_hitshipo_cpost_auto_label'];
		} else {
			$data['shipping_hitshipo_cpost_auto_label'] = $this->config->get('shipping_hitshipo_cpost_auto_label');
		}

		if (isset($this->request->post['shipping_hitshipo_cpost_auto_status'])) {
			$data['shipping_hitshipo_cpost_auto_status'] = $this->request->post['shipping_hitshipo_cpost_auto_status'];
		} else {
			$data['shipping_hitshipo_cpost_auto_status'] = $this->config->get('shipping_hitshipo_cpost_auto_status');
		}

		if (isset($this->request->post['shipping_hitshipo_cpost_send_mail_to'])) {
			$data['shipping_hitshipo_cpost_send_mail_to'] = $this->request->post['shipping_hitshipo_cpost_send_mail_to'];
		} else {
			$data['shipping_hitshipo_cpost_send_mail_to'] = $this->config->get('shipping_hitshipo_cpost_send_mail_to');
		}
				
		if (isset($this->request->post['shipping_hitshipo_cpost_cod'])) {
			$data['shipping_hitshipo_cpost_cod'] = $this->request->post['shipping_hitshipo_cpost_cod'];
		} else {
			$data['shipping_hitshipo_cpost_cod'] = $this->config->get('shipping_hitshipo_cpost_cod');
		}
		
		if (isset($this->request->post['shipping_hitshipo_cpost_dropoff_type'])) {
			$data['shipping_hitshipo_cpost_dropoff_type'] = $this->request->post['shipping_hitshipo_cpost_dropoff_type'];
		} else {
			$data['shipping_hitshipo_cpost_dropoff_type'] = $this->config->get('shipping_hitshipo_cpost_dropoff_type');
		}
		
		if (isset($this->request->post['shipping_hitshipo_cpost_duty_type'])) {
			$data['shipping_hitshipo_cpost_duty_type'] = $this->request->post['shipping_hitshipo_cpost_duty_type'];
		} else {
			$data['shipping_hitshipo_cpost_duty_type'] = $this->config->get('shipping_hitshipo_cpost_duty_type');
		}
		if (isset($this->request->post['shipping_hitshipo_cpost_output_type'])) {
			$data['shipping_hitshipo_cpost_output_type'] = $this->request->post['shipping_hitshipo_cpost_output_type'];
		} else {
			$data['shipping_hitshipo_cpost_output_type'] = $this->config->get('shipping_hitshipo_cpost_output_type');
		}

		if (isset($this->request->post['shipping_hitshipo_cpost_non_del_hand'])) {
			$data['shipping_hitshipo_cpost_non_del_hand'] = $this->request->post['shipping_hitshipo_cpost_non_del_hand'];
		} else {
			$data['shipping_hitshipo_cpost_non_del_hand'] = $this->config->get('shipping_hitshipo_cpost_non_del_hand');
		}

		if (isset($this->request->post['shipping_hitshipo_cpost_shipment_content'])) {
			$data['shipping_hitshipo_cpost_shipment_content'] = $this->request->post['shipping_hitshipo_cpost_shipment_content'];
		} else {
			$data['shipping_hitshipo_cpost_shipment_content'] = $this->config->get('shipping_hitshipo_cpost_shipment_content');
		}
		if (isset($this->request->post['shipping_hitshipo_cpost_logo'])) {
			$data['shipping_hitshipo_cpost_logo'] = $this->request->post['shipping_hitshipo_cpost_logo'];
		} else {
			$data['shipping_hitshipo_cpost_logo'] = $this->config->get('shipping_hitshipo_cpost_logo');
		}

		//thilak
		
		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');
		
		$this->response->setOutput($this->load->view('extension/shipping/hitshipo_cpost', $data));
	}
	
	protected function validate() {
		if (!$this->user->hasPermission('modify', 'extension/shipping/hitshipo_cpost')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		if (!$this->request->post['shipping_hitshipo_cpost_username']) {
			$this->error['name'] = $this->language->get('error_name');
		}

		if (!$this->request->post['shipping_hitshipo_cpost_password']) {
			$this->error['password'] = $this->language->get('error_password');
		}

		if (!$this->request->post['shipping_hitshipo_cpost_customer_num']) {
			$this->error['customer'] = $this->language->get('error_customer');
		}

		// if (!$this->request->post['shipping_hitshipo_cpost_contract_id']) {
		// 	$this->error['contract'] = $this->language->get('error_contract');
		// }

		if (!$this->request->post['shipping_hitshipo_cpost_postcode']) {
			$this->error['postcode'] = $this->language->get('error_postcode');
		}

		return !$this->error;
	}
}
