<?php

class ControllerExtensionModuleOutofstock extends Controller {
	private $error = array();

	public function index() {
		$this->load->language('extension/module/outofstock');

		$this->document->setTitle($this->language->get('heading_title'));
		$this->load->model('setting/setting');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
			$this->model_setting_setting->editSetting('module_outofstock', $this->request->post);

			$this->session->data['success'] = $this->language->get('text_success');

			$this->response->redirect($this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=module', true));
		}

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		if (isset($this->error['btntext'])) {
			$data['error_btntext'] = $this->error['btntext'];
		} else {
			$data['error_btntext'] = '';
		}

		$data['breadcrumbs'] = [];

		$data['breadcrumbs'][] = [
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'])
		];

		$data['breadcrumbs'][] = [
			'text' => $this->language->get('text_extension'),
			'href' => $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=module')
		];

		$data['breadcrumbs'][] = [
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('extension/module/outofstock', 'user_token=' . $this->session->data['user_token'])
		];

		$data['action'] = $this->url->link('extension/module/outofstock', 'user_token=' . $this->session->data['user_token'], true);
		$data['cancel'] = $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=module', true);

		if (isset($this->request->post['module_outofstock_status'])) {
			$data['module_outofstock_status'] = $this->request->post['module_outofstock_status'];
		} else {
			$data['module_outofstock_status'] = $this->config->get('module_outofstock_status');
		}

		if (isset($this->request->post['module_outofstock_btntext'])) {
			$data['module_outofstock_btntext'] = $this->request->post['module_outofstock_btntext'];
		} else {
			$data['module_outofstock_btntext'] = $this->config->get('module_outofstock_btntext');
		}

		if (isset($this->request->post['module_outofstock_btncolor'])) {
			$data['module_outofstock_btncolor'] = $this->request->post['module_outofstock_btncolor'];
		} else {
			$data['module_outofstock_btncolor'] = $this->config->get('module_outofstock_btncolor');
		}

		if (isset($this->request->post['module_outofstock_btntextcolor'])) {
			$data['module_outofstock_btntextcolor'] = $this->request->post['module_outofstock_btntextcolor'];
		} else {
			$data['module_outofstock_btntextcolor'] = $this->config->get('module_outofstock_btntextcolor');
		}

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('extension/module/outofstock', $data));
	}

	protected function validate() {

		$this->load->language('extension/module/outofstock');

		$json = [];

		if ($this->request->post['module_outofstock_btntext'] == '') {
			$this->error['btntext'] = $this->language->get('error_outofstock_btntext');
		}

		if (!$this->user->hasPermission('modify', 'extension/module/outofstock')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		return !$this->error;

	}

	public function install() {

		$this->__registerEvents();
		
	}

	protected function __registerEvents() {
	        
	    // loading event model
	    $this->load->model('setting/event');

	    $this->model_setting_event->addEvent('outofstock_header', 'catalog/view/common/header/after', 'extension/module/outofstock/postViewHeader', 1, 1);

	    $this->model_setting_event->addEvent('outofstock_footer', 'catalog/view/common/footer/after', 'extension/module/outofstock/postViewFooter', 1, 1);

		$this->load->model('setting/setting');

	    $this->model_setting_setting->editSetting('module_outofstock', ['module_outofstock_btntext' => 'Out Of Stock', 'module_outofstock_textcolor' => "#ffffff", 'module_outofstock_btncolor' => "#1f90bb",'module_outofstock_btntextcolor' =>'#ffffff']);
	}

	public function uninstall() {
		$this->load->model('setting/event');
		$this->model_setting_event->deleteEventByCode('outofstock_header');
		$this->model_setting_event->deleteEventByCode('outofstock_footer');

        $this->load->model('setting/setting');
        $this->model_setting_setting->editSetting('module_outofstock', ['module_outofstock_status' => 0]);
	}

}